function [SA, SAl, SAr]=skewnessIT2(A)

%
% [SA, SAl, SAr]=skewnessIT2(A)
%
% To compute the skewness of an IT2 FS, which is defined by nine
% parameters (a, b, c, d, e, f, g, i, h) shown in Fig. 1 of Readme.doc. 
%
% D. Wu and J.M. Mendel, "Uncertainty measures for interSAl type-2 fuzzy
% set," Information Sciences, 177, pp. 5378-5393, 2007.
%
% J. M. Mendel and Dongrui Wu, Perceptual Computing: Aiding People in Making Subjective Judgments, 
% Wiley-IEEE Press, 2010.
%
% Dongrui WU (dongruiw@usc.edu), 3/24/2009
%
% A: an IT2 FS represented by 9 parameters.
% SA: center of skewness of A
% SAl: left bound of the skewness
% SAr: right bound of the skewness

Xs=linspace(A(1),A(4),100);
UMF=mg(Xs,A(1:4),[0 1 1 0]);
LMF=mg(Xs,A(5:8),[0 A(9) A(9) 0]);
Xs=(Xs-centroidIT2(A)).^3;
SAl=EKM(Xs,LMF,UMF,-1);
SAr=EKM(Xs,LMF,UMF,1);
SA=(SAl+SAr)/2;
